/*
 * Decompiled with CFR 0.152.
 */
package com.github.monun.survival.tap.event;

import com.github.monun.survival.tap.collection.SortedList;
import com.github.monun.survival.tap.event.EventEntityProvider;
import com.github.monun.survival.tap.event.RegisteredEntityHandler;
import java.util.Collection;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\rR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/github/monun/survival/tap/event/EntityHandlerList;", "", "()V", "handlerList", "Lcom/github/monun/survival/tap/collection/SortedList;", "Lcom/github/monun/survival/tap/event/RegisteredEntityHandler;", "handlers", "", "[Lcom/github/monun/survival/tap/event/RegisteredEntityHandler;", "registeredHandlers", "getRegisteredHandlers", "()[Lcom/github/monun/tap/event/RegisteredEntityHandler;", "bake", "", "callEvent", "event", "Lorg/bukkit/event/Event;", "provider", "Lcom/github/monun/survival/tap/event/EventEntityProvider;", "register", "handler", "unregister", "listener", "Lorg/bukkit/event/Listener;", "unregisterAll", "api"})
public final class EntityHandlerList {
    private final SortedList<RegisteredEntityHandler> handlerList = new SortedList();
    private RegisteredEntityHandler[] handlers;

    public final synchronized void register(@NotNull RegisteredEntityHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.handlers = null;
        this.handlerList.add(handler);
    }

    public final synchronized void unregister(@NotNull RegisteredEntityHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.handlers = null;
        this.handlerList.binaryRemove(handler);
    }

    public final void unregister(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.handlers = null;
        this.handlerList.removeIf(new Predicate<RegisteredEntityHandler>(listener2){
            final /* synthetic */ Listener $listener;

            public final boolean test(@NotNull RegisteredEntityHandler handler) {
                Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
                if (this.$listener == handler.getListener()) {
                    handler.remove();
                    return true;
                }
                return false;
            }
            {
                this.$listener = listener2;
            }
        });
    }

    public final synchronized void bake() {
        if (this.handlers != null) {
            return;
        }
        Collection $this$toTypedArray$iv = this.handlerList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        RegisteredEntityHandler[] registeredEntityHandlerArray = thisCollection$iv.toArray(new RegisteredEntityHandler[0]);
        if (registeredEntityHandlerArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        this.handlers = registeredEntityHandlerArray;
    }

    private final RegisteredEntityHandler[] getRegisteredHandlers() {
        RegisteredEntityHandler[] handlers = this.handlers;
        while (handlers == null) {
            this.bake();
            handlers = this.handlers;
        }
        return handlers;
    }

    public final void callEvent(@NotNull Event event, @NotNull EventEntityProvider provider) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        for (RegisteredEntityHandler handler : this.getRegisteredHandlers()) {
            if (provider != handler.getStatement().getProvider()) continue;
            handler.callEvent(event);
        }
    }

    public final void unregisterAll() {
        for (RegisteredEntityHandler registeredEntityHandler : this.handlerList) {
            registeredEntityHandler.remove();
        }
        this.handlerList.clear();
        this.handlers = null;
    }
}

